/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.unnamedanimalmod.common.entity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Blocks;
import net.minecraft.block.TurtleEggBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.pathfinding.WalkAndSwimNodeProcessor;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import teamdraco.unnamedanimalmod.init.UAMItems;

public class PlatypusEntity
extends AnimalEntity {
    public PlatypusEntity(EntityType<? extends AnimalEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new MoveHelperController(this);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70138_W = 1.0f;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new Navigator(this, this.field_70170_p);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public static boolean canSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150349_c && worldIn.func_226659_b_(pos, 0) > 8;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new BreedGoal((AnimalEntity)this, 1.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 2.0, 1){

            public boolean func_75250_a() {
                return super.func_75250_a() && PlatypusEntity.this.func_70090_H();
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new WanderGoal(this, 1.0, 10));
        this.field_70714_bg.func_75776_a(3, (Goal)new GoToWaterGoal(this, 1.0));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.15);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151070_bp;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        if (worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a)) {
            return 10.0f;
        }
        return TurtleEggBlock.func_203168_a((IBlockReader)worldIn, (BlockPos)pos) ? 10.0f : worldIn.func_205052_D(pos) - 0.5f;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_77973_b() == Items.field_151133_ar && this.func_70089_S() && !this.func_70631_g_()) {
            this.func_184185_a(SoundEvents.field_187620_cL, 1.0f, 1.0f);
            heldItem.func_190918_g(1);
            ItemStack itemstack1 = new ItemStack((IItemProvider)UAMItems.PLATYPUS_BUCKET.get());
            this.setBucketData(itemstack1);
            if (!this.field_70170_p.field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, itemstack1);
            }
            if (heldItem.func_190926_b()) {
                player.func_184611_a(hand, itemstack1);
            } else if (!player.field_71071_by.func_70441_a(itemstack1)) {
                player.func_71019_a(itemstack1, false);
            }
            this.func_70106_y();
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    protected void setBucketData(ItemStack bucket) {
        if (this.func_145818_k_()) {
            bucket.func_200302_a(this.func_200201_e());
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)UAMItems.PLATYPUS_SPAWN_EGG.get());
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.1f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!source.func_82725_o() && source.func_76364_f() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)source.func_76364_f();
            if (!source.func_94541_c()) {
                livingentity.func_195064_c(new EffectInstance(Effects.field_76436_u, 100, 0));
            }
        }
        return super.func_70097_a(source, amount);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        this.func_199701_a_(new ItemStack((IItemProvider)UAMItems.PLATYPUS_EGG.get(), this.func_70681_au().nextInt(1) + 1));
        this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        ((AnimalEntity)p_241840_2_).func_70875_t();
        return null;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return null;
    }

    static class GoToWaterGoal
    extends MoveToBlockGoal {
        private final PlatypusEntity platypus;

        private GoToWaterGoal(PlatypusEntity platypus, double speedIn) {
            super((CreatureEntity)platypus, platypus.func_70631_g_() ? 2.0 : speedIn, 24);
            this.platypus = platypus;
            this.field_203112_e = -1;
        }

        public boolean func_75253_b() {
            return !this.platypus.func_70090_H() && this.field_179493_e <= 1200 && this.func_179488_a((IWorldReader)this.platypus.field_70170_p, this.field_179494_b);
        }

        public boolean func_75250_a() {
            if (this.platypus.func_70631_g_() && !this.platypus.func_70090_H()) {
                return super.func_75250_a();
            }
            return !this.platypus.func_70090_H() && super.func_75250_a();
        }

        public boolean func_203108_i() {
            return this.field_179493_e % 160 == 0;
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            return worldIn.func_180495_p(pos).func_203425_a(Blocks.field_150355_j);
        }
    }

    static class WanderGoal
    extends RandomWalkingGoal {
        private final PlatypusEntity platypus;

        private WanderGoal(PlatypusEntity platypus, double speedIn, int chance) {
            super((CreatureEntity)platypus, speedIn, chance);
            this.platypus = platypus;
        }

        public boolean func_75250_a() {
            return !this.field_75457_a.func_70090_H() && super.func_75250_a();
        }
    }

    static class Navigator
    extends SwimmerPathNavigator {
        Navigator(PlatypusEntity platypus, World worldIn) {
            super((MobEntity)platypus, worldIn);
        }

        protected boolean func_75485_k() {
            return true;
        }

        protected PathFinder func_179679_a(int p_179679_1_) {
            this.field_179695_a = new WalkAndSwimNodeProcessor();
            return new PathFinder(this.field_179695_a, p_179679_1_);
        }

        public boolean func_188555_b(BlockPos pos) {
            if (this.field_75515_a instanceof PlatypusEntity) {
                return !this.field_75513_b.func_180495_p(pos.func_177977_b()).func_196958_f();
            }
            return !this.field_75513_b.func_180495_p(pos.func_177977_b()).func_196958_f();
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final PlatypusEntity platypus;

        MoveHelperController(PlatypusEntity platypus) {
            super((MobEntity)platypus);
            this.platypus = platypus;
        }

        private void updateSpeed() {
            if (this.platypus.func_70090_H()) {
                this.platypus.func_213317_d(this.platypus.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
                if (this.platypus.func_70631_g_()) {
                    this.platypus.func_70659_e(Math.max(this.platypus.func_70689_ay() / 3.0f, 0.06f));
                }
            } else if (this.platypus.field_70122_E) {
                this.platypus.func_70659_e(Math.max(this.platypus.func_70689_ay() / 1.0f, 0.06f));
            }
        }

        public void func_75641_c() {
            this.updateSpeed();
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.platypus.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.platypus.func_226277_ct_();
                double d1 = this.field_75647_c - this.platypus.func_226278_cu_();
                double d2 = this.field_75644_d - this.platypus.func_226281_cx_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.platypus.field_70761_aq = this.platypus.field_70177_z = this.func_75639_a(this.platypus.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.platypus.func_233637_b_(Attributes.field_233821_d_));
                this.platypus.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.platypus.func_70689_ay(), (float)f1));
                this.platypus.func_213317_d(this.platypus.func_213322_ci().func_72441_c(0.0, (double)this.platypus.func_70689_ay() * (d1 /= d3) * 0.1, 0.0));
            } else {
                this.platypus.func_70659_e(0.0f);
            }
        }
    }
}

